<?php

namespace Comitium5\PaymentBundle\Payments\Client;

use Comitium5\PaymentBundle\Components\Interfaces\HttpClientInterface;
use Comitium5\PaymentBundle\Components\Interfaces\PaymentClientInterface;

/**
 * Class RedSysHttpClientService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Payments\Client
 */
class RedSysHttpClientService implements PaymentClientInterface
{
    /**
     * @var HttpClientInterface
     */
    protected $client;

    /**
     * PaymentClient constructor.
     *
     * @param $client
     */
    public function __construct(HttpClientInterface $client)
    {
        $this->client = $client;
    }

    /**
     * @param string $uri
     * @param array $parameters
     *
     * @return mixed|\Psr\Http\Message\ResponseInterface
     */
    public function pay($uri, array $parameters)
    {
        return $this
            ->client
            ->post($uri, $parameters);
    }
}
