<?php

namespace Comitium5\PaymentBundle\Components\Helpers\RedSys;

/**
 * Class Tokenizer
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Helpers\RedSys
 */
class Tokenizer
{
    /**
     * @param $parameters
     * @param $privateKey
     * @param $tpvOrderId
     *
     * @return string
     */
    public static function generateRedSysSignature($parameters, $privateKey, $tpvOrderId)
    {
        $cipherText = self::encrypt_3DES($tpvOrderId, $privateKey);

        return base64_encode(hash_hmac('sha256', $parameters, $cipherText, true));
    }

    /**
     * Method extracted from ApiRedsys.php library
     *
     * @param $message
     * @param $key
     *
     * @return false|string
     */
    private static function encrypt_3DES($message, $key){
        $l = ceil(strlen($message) / 8) * 8;

        return substr(
            openssl_encrypt(
                $message . str_repeat("\0", $l - strlen($message)),
                'des-ede3-cbc',
                base64_decode($key),
                OPENSSL_RAW_DATA,
                "\0\0\0\0\0\0\0\0"
            ),
            0,
            $l
        );
    }
}
