<?php

namespace Tests\Components\Client;

use Comitium5\PaymentBundle\Components\Client\GuzzleClient;
use GuzzleHttp\Client;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Middleware;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Response;
use Tests\UnitTestCase;

/**
 * Class GuzzleClientTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Tests\Components\Client
 */
class GuzzleClientTest extends UnitTestCase
{
    /**
     *
     */
    public function testPost()
    {
        $container = [];

        $guzzleClient = new GuzzleClient($this->client($container));

        $guzzleClient->post("https://www.foo.com", [
            "foo" => "bar",
        ]);

        foreach ($container as $key => $transaction) {
            /**
             * @var $request Request
             */
            $request = $transaction['request'];

            $this->assertEquals('https', $request->getUri()->getScheme());
            $this->assertEquals('www.foo.com', $request->getHeader('Host')[0]);
        }
    }

    /**
     * @param array $container
     *
     * @return Client
     */
    private function client(array &$container)
    {
        $mock = new MockHandler([
            new Response(200)
        ]);

        $history = Middleware::history($container);

        $stack = HandlerStack::create($mock);

        $stack->push($history);

        return new Client(['handler' => $stack]);
    }
}
