<?php

namespace Comitium5\PaymentBundle\Payments\RedSys;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysParameters;
use Comitium5\PaymentBundle\Components\Helpers\RedSys\Tokenizer;
use Comitium5\PaymentBundle\Components\Model\RedSys\RedSysResponse;

/**
 * Class RedSysValidationService
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Payments\RedSys
 */
class RedSysValidationService
{
    /**
     * @var
     */
    protected $privateKey;

    /**
     * RedSysValidationService constructor.
     *
     * @param $privateKey
     */
    public function __construct($privateKey)
    {
        $this->privateKey = $privateKey;
    }

    /**
     * @param $merchantParameters
     * @param $requestSignature
     *
     * @return RedSysResponse
     */
    public function validate($merchantParameters, $requestSignature)
    {
        $parameters = base64_decode(strtr($merchantParameters, '-_', '+/'));
        $parameters = json_decode($parameters, true);

        $orderId = $parameters[RedSysParameters::ORDER];

        $redSysSignature = strtr(Tokenizer::generateRedSysSignature(
            $merchantParameters, $this->privateKey, $orderId
        ), '+/', '-_');

        if ($redSysSignature !== $requestSignature) {
            return new RedSysResponse(false, $parameters);
        }

        $response = isset($parameters[RedSysParameters::RESPONSE]) ? intval($parameters[RedSysParameters::RESPONSE]) : 0;
        $isValid = $response >= 0 && $response <= 100;

        return new RedSysResponse($isValid, $parameters);
    }
}
