<?php

namespace Comitium5\PaymentBundle\Components\Helpers\RedSys;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysParameters;

/**
 * Class Tokenizer
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Helpers\RedSys
 */
class Tokenizer
{
    /**
     * @param string $parameters
     * @param string $privateKey
     * @param mixed  $tpvOrderId
     *
     * @return string
     */
    public static function generateRedSysSignature($parameters, $privateKey, $tpvOrderId)
    {
        $bytes = [0, 0, 0, 0, 0, 0, 0, 0];
        $iv = implode(array_map("chr", $bytes));

        $cipherText = mcrypt_encrypt(MCRYPT_3DES, base64_decode($privateKey), $tpvOrderId, MCRYPT_MODE_CBC, $iv);

        return base64_encode(hash_hmac('sha256', $parameters, $cipherText, true));
    }
}
