<?php

namespace Comitium5\PaymentBundle\Components\Helpers\RedSys;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysParameters;
use Comitium5\PaymentBundle\Components\Interfaces\RedSysConcurrentTransactionInterface;
use Comitium5\PaymentBundle\Components\Interfaces\RedSysTransactionInterface;

/**
 * Class Encoder
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Helpers\RedSys
 */
class Encoder
{
    /**
     * @param RedSysTransactionInterface $transaction
     *
     * @return string
     */
    public static function encodeParamsForSignature(RedSysTransactionInterface $transaction)
    {
        $params = [
            RedSysParameters::MERCHANT_PRODUCT_DESCRIPTION => $transaction->getProductDescription(),
            RedSysParameters::MERCHANT_NAME                => $transaction->getMerchantName(),
            RedSysParameters::MERCHANT_TITULAR             => $transaction->getTitular(),
            RedSysParameters::MERCHANT_CONSUMER_LANGUAGE   => $transaction->getConsumerLanguage(),
            RedSysParameters::MERCHANT_CODE                => $transaction->getMerchantCode(),
            RedSysParameters::MERCHANT_TERMINAL            => $transaction->getTerminal(),
            RedSysParameters::MERCHANT_ORDER               => $transaction->getOrderIdentifier(),
            RedSysParameters::MERCHANT_AMOUNT              => RedSysHelper::calculatePrice($transaction->getAmount()),
            RedSysParameters::MERCHANT_CURRENCY            => $transaction->getCurrency(),
            RedSysParameters::MERCHANT_TRANSACTION_TYPE    => $transaction->getTransactionType(),
            RedSysParameters::MERCHANT_MERCHANT_DATA       => self::encodePrivateData($transaction->getMerchantData()),
        ];

        if ($transaction instanceof RedSysConcurrentTransactionInterface) {
            $params = array_merge($params, [
                RedSysParameters::MERCHANT_IDENTIFIER     => $transaction->getMerchantIdentifier(),
                RedSysParameters::MERCHANT_DIRECT_PAYMENT => $transaction->isDirectPayment(),
                RedSysParameters::MERCHANT_EXCEPSCA       => 'MIT',
            ]);
        } else {
            $params = array_merge($params, [
                RedSysParameters::MERCHANT_URL                 => $transaction->getMerchantURL(),
                RedSysParameters::MERCHANT_URL_OK              => $transaction->getUrlOK(),
                RedSysParameters::MERCHANT_URL_KO              => $transaction->getUrlKO(),
                RedSysParameters::MERCHANT_PAY_METHODS         => $transaction->getPayMethods(),
            ]);
        }

        return base64_encode(json_encode($params));
    }

    /**
     * @param array $privateData
     *
     * @return string
     */
    public static function encodePrivateData(array $privateData)
    {
        return base64_encode(json_encode($privateData));
    }
}
