<?php

namespace Comitium5\PaymentBundle\Components\Helpers\RedSys;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysConfig;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysParameters;
use Comitium5\PaymentBundle\Components\Interfaces\RedSysTransactionInterface;

/**
 * Class RedSysHelper
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Helpers\RedSys
 */
class RedSysHelper
{
    /**
     * @param $price
     *
     * @return float
     */
    public static function calculatePrice($price)
    {
        return round($price * 100);
    }

    /**
     * @param RedSysTransactionInterface $transaction
     * @param $privateKey
     *
     * @return array
     */
    public static function generateFormParameters(RedSysTransactionInterface $transaction, $privateKey)
    {
        $params    = Encoder::encodeParamsForSignature($transaction);
        $signature = Tokenizer::generateRedSysSignature($params, $privateKey, $transaction->getOrderIdentifier());

        return [
            RedSysParameters::SIGNATURE_VERSION   => RedSysConfig::SIGNATURE_VERSION,
            RedSysParameters::MERCHANT_PARAMETERS => $params,
            RedSysParameters::SIGNATURE           => $signature,
        ];
    }
}