<?php

namespace Comitium5\PaymentBundle\Components\Helpers\RedSys;

/**
 * Class Decoder
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Helpers\RedSys
 */
class Decoder
{
    /**
     * @param $privateData
     *
     * @return array
     */
    public static function decodePrivateData($privateData)
    {
        if (empty($privateData)) {
            return [];
        }

        $privateData = base64_decode($privateData);

        return json_decode($privateData, true);
    }

    /**
     * @param $merchantParameters
     *
     * @return bool|mixed|string
     */
    public static function decodeRequestParams($merchantParameters)
    {
        $parameters = base64_decode(strtr($merchantParameters, '-_', '+/'));

        $parameters = json_decode($parameters, true);

        return $parameters;
    }
}