<?php

namespace Comitium5\PaymentBundle\Components\Client;

use Comitium5\PaymentBundle\Components\Interfaces\HttpClientInterface;
use GuzzleHttp\Client;

/**
 * Class GuzzleClient
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Components\Client
 */
class GuzzleClient implements HttpClientInterface
{
    /**
     * @var Client
     */
    protected $client;

    /**
     * GuzzleClient constructor.
     *
     * @param Client $client
     */
    public function __construct(Client $client)
    {
        $this->client = $client;
    }

    /**
     * @param string $uri
     * @param array $options
     *
     * @return mixed|\Psr\Http\Message\ResponseInterface
     */
    public function post($uri, array $options = [])
    {
        return $this
            ->client
            ->post($uri, [
                "form_params" => $options
            ]);
    }
}
