<?php

namespace Comitium5\PaymentBundle\DependencyInjection;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysConfig;
use Symfony\Component\Config\Definition\Builder\TreeBuilder;
use Symfony\Component\Config\Definition\ConfigurationInterface;

/**
 * This is the class that validates and merges configuration from your app/config files.
 *
 * To learn more see {@link http://symfony.com/doc/current/cookbook/bundles/configuration.html}
 */
class Configuration implements ConfigurationInterface
{
    /**
     * {@inheritdoc}
     */
    public function getConfigTreeBuilder()
    {
        $treeBuilder = new TreeBuilder();
        $rootNode = $treeBuilder->root('comitium5_payment');

        $rootNode->children()
            ->scalarNode('stripe_public_key')->defaultNull()->end()
            ->scalarNode('stripe_private_key')->defaultNull()->end()
            ->scalarNode('redsys_private_key')->defaultNull()->end()
            ->scalarNode('redsys_fuc')->defaultNull()->end()
            ->scalarNode('redsys_endpoint')->defaultValue(RedSysConfig::SERVICE_PAY_ENDPOINT)->end()
            ->scalarNode('redsys_endpoint_test')->defaultValue(RedSysConfig::SERVICE_PAY_ENDPOINT_TEST)->end()
            ->end();

        return $treeBuilder;
    }
}
