<?php

namespace Comitium5\PaymentBundle\Components\ValueObjects;

/**
 * Class PaymentObject
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Components\ValueObjects
 */
class PaymentObject
{
    /**
     * @var string|\Psr\Http\Message\ResponseInterface
     */
    protected $data;

    /**
     * PaymentObject constructor.
     *
     * @param string|\Psr\Http\Message\ResponseInterface $data
     */
    public function __construct($data)
    {
        $this->data = $data;
    }

    /**
     * @return \Psr\Http\Message\ResponseInterface|string
     */
    public function getData()
    {
        return $this->data;
    }
}
