<?php

namespace Comitium5\PaymentBundle\Components\Factories\Stripe;

use Comitium5\PaymentBundle\Components\Factories\AbstractFactory;
use Comitium5\PaymentBundle\Components\Interfaces\FactoryInterface;
use Comitium5\PaymentBundle\Components\Interfaces\TransactionInterface;

/**
 * Class TransactionFactory
 *
 * @author Daniel J. Pérez <danieljordi@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Factories\Stripe
 */
class TransactionFactory extends AbstractFactory
{
    /**
     * @var FactoryInterface
     */
    protected $cardFactory;

    /**
     * TransactionFactory constructor.
     * @param FactoryInterface $cardFactory
     */
    public function __construct(FactoryInterface $cardFactory)
    {
        $this->cardFactory = $cardFactory;
    }

    /**
     * @return TransactionInterface
     */
    public function create()
    {
        $classNamespace = $this->getNamespace();

        $transaction = new $classNamespace();

        $card = $this->cardFactory->create();

        $transaction->setCard($card);

        return $transaction;
    }
}