<?php

namespace Tests\Payments\Client;

use Comitium5\PaymentBundle\Components\Client\GuzzleClient;
use Comitium5\PaymentBundle\Payments\Client\RedSysHttpClientService;
use GuzzleHttp\Client;
use GuzzleHttp\Handler\MockHandler;
use GuzzleHttp\HandlerStack;
use GuzzleHttp\Middleware;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\Psr7\Response;
use Tests\UnitTestCase;

/**
 * Class RedSysHttpClientServiceTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Tests\Payments\Client
 */
class RedSysHttpClientServiceTest extends UnitTestCase
{
    /**
     *
     */
    public function testPay()
    {
        $container = [];

        $guzzleClient = new GuzzleClient($this->client($container));

        $service = new RedSysHttpClientService($guzzleClient);

        $service->pay("/sis/realizarPago", [
            "foo"  => "bar",
            "test" => 1,
        ]);

        foreach ($container as $key => $transaction) {
            /**
             * @var $request Request
             */
            $request = $transaction['request'];

            $this->assertEquals('https', $request->getUri()->getScheme());
            $this->assertEquals('www.foo.com', $request->getHeader('Host')[0]);
            $this->assertEquals('/sis/realizarPago', $request->getUri()->getPath());
            $this->assertEquals("foo=bar&test=1", $request->getBody()->getContents());
        }
    }

    /**
     * @param array $container
     *
     * @return Client
     */
    private function client(array &$container)
    {
        $mock = new MockHandler([
            new Response(200)
        ]);

        $history = Middleware::history($container);

        $stack = HandlerStack::create($mock);

        $stack->push($history);

        return new Client([
            'handler'  => $stack,
            'base_uri' => "https://www.foo.com",
        ]);
    }
}
