<?php

namespace Tests\Components\Model\RedSys;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysConfig;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysCurrency;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysLang;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysPayMethods;
use Comitium5\PaymentBundle\Components\Model\RedSys\Transaction;
use Tests\UnitTestCase;

/**
 * Class TransactionTest
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Tests\Model\RedSys
 */
class TransactionTest extends UnitTestCase
{
    /**
     * @dataProvider transactionData
     *
     * @param $amount
     * @param $productDescription
     * @param $titular
     * @param $merchantCode
     * @param $merchantURL
     * @param $urlOK
     * @param $urlKO
     * @param $merchantName
     * @param array $merchantData
     */
    public function testObject(
        $amount,
        $productDescription,
        $titular,
        $merchantCode,
        $merchantURL,
        $urlOK,
        $urlKO,
        $merchantName,
        $merchantData = []
    ) {
        $transaction = new Transaction(
            $amount,
            $productDescription,
            $titular,
            $merchantCode,
            $merchantURL,
            $urlOK,
            $urlKO,
            $merchantName,
            $merchantData
        );

        $this->assertEquals($amount, $transaction->getAmount());
        $this->assertEquals($productDescription, $transaction->getProductDescription());
        $this->assertEquals($titular, $transaction->getTitular());
        $this->assertEquals($merchantCode, $transaction->getMerchantCode());
        $this->assertEquals($merchantURL, $transaction->getMerchantURL());
        $this->assertEquals($urlOK, $transaction->getUrlOK());
        $this->assertEquals($urlKO, $transaction->getUrlKO());
        $this->assertEquals($merchantName, $transaction->getMerchantName());
        $this->assertEquals($merchantData, $transaction->getMerchantData());
        $this->assertEquals(RedSysCurrency::EURO_CURRENCY, $transaction->getCurrency());
        $this->assertEquals(RedSysLang::SPANISH, $transaction->getConsumerLanguage());
        $this->assertEquals(RedSysConfig::TERMINAL, $transaction->getTerminal());
        $this->assertEquals(RedSysConfig::TRANSACTION_TYPE, $transaction->getTransactionType());
        $this->assertEquals(RedSysPayMethods::CREDIT_CARD, $transaction->getPayMethods());
        $this->assertEquals(date('ymdmis'), $transaction->getOrderIdentifier());
    }

    /**
     * @return array
     */
    public function transactionData()
    {
        return [
            [
                300,
                "Product description",
                "Foo",
                "999008881",
                "www.foo.es",
                "www.foo.es/ok",
                "www.foo.es/ko",
                "Bar",
                [
                    "data1" => "foo",
                    "data2" => "bar",
                ],
            ],
        ];
    }
}
