<?php

namespace Comitium5\PaymentBundle\Components\Model\RedSys;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysConfig;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysCurrency;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysLang;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysPayMethods;
use Comitium5\PaymentBundle\Components\Interfaces\RedSysConcurrentTransactionInterface;

/**
 * Class ConcurrentTransaction
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Components\Model\RedSys
 */
class ConcurrentTransaction extends Transaction implements RedSysConcurrentTransactionInterface
{
    /**
     * @var string
     */
    protected $merchantIdentifier;

    /**
     * @var bool
     */
    protected $directPayment;

    /**
     * ConcurrentTransaction constructor.
     *
     * @param $amount
     * @param $productDescription
     * @param $titular
     * @param $merchantCode
     * @param $merchantURL
     * @param $urlOK
     * @param $urlKO
     * @param $merchantName
     * @param array $merchantData
     * @param null|string $orderIdentifier
     * @param string $merchantIdentifier
     * @param bool $directPayment
     * @param string $currency
     * @param string $consumerLanguage
     * @param int $terminal
     * @param int $transactionType
     * @param string $payMethods
     */
    public function __construct(
        $amount,
        $productDescription,
        $titular,
        $merchantCode,
        $merchantURL,
        $urlOK,
        $urlKO,
        $merchantName,
        $merchantData = [],
        $orderIdentifier = null,
        $merchantIdentifier = RedSysConfig::DEFAULT_IDENTIFIER,
        $directPayment = true,
        $currency = RedSysCurrency::EURO_CURRENCY,
        $consumerLanguage = RedSysLang::SPANISH,
        $terminal = RedSysConfig::TERMINAL,
        $transactionType = RedSysConfig::TRANSACTION_TYPE,
        $payMethods = RedSysPayMethods::CREDIT_CARD
    ) {
        parent::__construct(
            $amount,
            $productDescription,
            $titular,
            $merchantCode,
            $merchantURL,
            $urlOK,
            $urlKO,
            $merchantName,
            $merchantData,
            $orderIdentifier,
            $currency,
            $consumerLanguage,
            $terminal,
            $transactionType,
            $payMethods
        );

        $this->merchantIdentifier = $merchantIdentifier;
        $this->directPayment      = $directPayment;
    }

    /**
     * @return string
     */
    public function getMerchantIdentifier()
    {
        return $this->merchantIdentifier;
    }

    /**
     * @return bool
     */
    public function isDirectPayment()
    {
        return $this->directPayment;
    }
}
