<?php

namespace Comitium5\PaymentBundle\Components\Factories\Client;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysConfig;
use Comitium5\PaymentBundle\Components\Client\GuzzleClient;
use GuzzleHttp\Client;
use Comitium5\PaymentBundle\Payments\Client\RedSysHttpClientService;

/**
 * Class RedSysGuzzleFactory
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Components\Factories\Client
 */
class RedSysGuzzleFactory
{
    /**
     * @param array $headers
     * @param bool $verify
     * @param bool $httpErrors
     *
     * @return RedSysHttpClientService
     */
    public function create($headers = [], $verify = false, $httpErrors = true)
    {
        return $this->createClient(
            RedSysConfig::SERVICE_PAY_ENDPOINT,
            $headers,
            $verify,
            $httpErrors
        );
    }

    /**
     * @param array $headers
     * @param bool $verify
     * @param bool $httpErrors
     *
     * @return RedSysHttpClientService
     */
    public function createForTest($headers = [], $verify = false, $httpErrors = true)
    {
        return $this->createClient(
            RedSysConfig::SERVICE_PAY_ENDPOINT_TEST,
            $headers,
            $verify,
            $httpErrors
        );
    }

    /**
     * @param $endPoint
     * @param $headers
     * @param $verify
     * @param $httpErrors
     *
     * @return RedSysHttpClientService
     */
    private function createClient($endPoint, $headers, $verify, $httpErrors)
    {
        $httpClient = new GuzzleClient(new Client([
            'verify'      => $verify,
            'http_errors' => $httpErrors,
            'base_uri'    => $endPoint,
            'headers'     => $headers,
        ]));

        return new RedSysHttpClientService($httpClient);
    }
}
