<?php

namespace Comitium5\PaymentBundle\Payments\RedSys;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysConfig;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysParameters;
use Comitium5\PaymentBundle\Components\Helpers\RedSys\Encoder;
use Comitium5\PaymentBundle\Components\Helpers\RedSys\Tokenizer;
use Comitium5\PaymentBundle\Components\Interfaces\RedSysTransactionInterface;
use Comitium5\PaymentBundle\Components\Validators\RedSys\RedSysServiceValidator;

/**
 * Class RedSysPaymentService
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Payments\RedSys
 */
class RedSysPaymentService
{
    /**
     * @var RedSysTemplatingService
     */
    protected $templating;

    /**
     * @var string
     */
    protected $privateKey;

    /**
     * @var string
     */
    protected $fuc;

    /**
     * RedSysPaymentService constructor.
     *
     * @param RedSysTemplatingService $templating
     * @param null $privateKey
     * @param null $fuc
     */
    public function __construct(RedSysTemplatingService $templating, $privateKey = null, $fuc = null)
    {
        $this->templating = $templating;
        $this->privateKey = $privateKey;
        $this->fuc = $fuc;
    }

    /**
     * @param RedSysTransactionInterface $transaction
     * @param bool $testEnvironment
     *
     * @return string
     * @throws \Exception
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function pay(RedSysTransactionInterface $transaction, $testEnvironment = false)
    {
        RedSysServiceValidator::validate(
            $this->getPrivateKey(),
            $this->getFuc()
        );

        $params = Encoder::encodeParamsForSignature($transaction);
        $signature = Tokenizer::generateRedSysSignature($params, $this->getPrivateKey(), $transaction->getOrder());

        $formParameters = [
            RedSysParameters::SIGNATURE_VERSION   => RedSysConfig::SIGNATURE_VERSION,
            RedSysParameters::MERCHANT_PARAMETERS => $params,
            RedSysParameters::SIGNATURE           => $signature,
        ];

        return $this->templating->render([
            'tpvUrl' => $testEnvironment ? RedSysConfig::SERVICE_URL_TEST : RedSysConfig::SERVICE_URL,
            'params' => $formParameters,
        ]);
    }

    /**
     * @return string
     */
    public function getPrivateKey()
    {
        return $this->privateKey;
    }

    /**
     * @return string
     */
    public function getFuc()
    {
        return $this->fuc;
    }

    /**
     * @param null $privateKey
     * @param null $fuc
     */
    public function build($privateKey = null, $fuc = null)
    {
        $this->privateKey = $privateKey;
        $this->fuc = $fuc;
    }
}