<?php

namespace Comitium5\PaymentBundle\Components\Model\RedSys;

use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysConfig;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysCurrency;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysLang;
use Comitium5\PaymentBundle\Components\Constants\RedSys\RedSysPayMethods;
use Comitium5\PaymentBundle\Components\Interfaces\RedSysTransactionInterface;

/**
 * Class Transaction
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Model\RedSys
 */
class Transaction implements RedSysTransactionInterface
{
    /**
     * @var
     */
    protected $amount;

    /**
     * @var string
     */
    protected $order;

    /**
     * @var
     */
    protected $productDescription;

    /**
     * @var
     */
    protected $titular;

    /**
     * @var
     */
    protected $merchantCode;

    /**
     * @var
     */
    protected $merchantURL;

    /**
     * @var
     */
    protected $urlOK;

    /**
     * @var
     */
    protected $urlKO;

    /**
     * @var
     */
    protected $merchantName;

    /**
     * @var array
     */
    protected $merchantData;

    /**
     * @var
     */
    protected $payMethods;

    /**
     * @var string
     */
    protected $currency;

    /**
     * @var string
     */
    protected $consumerLanguage;

    /**
     * @var int
     */
    protected $terminal;

    /**
     * @var int
     */
    protected $transactionType;

    /**
     * Transaction constructor.
     *
     * @param $amount
     * @param $productDescription
     * @param $titular
     * @param $merchantCode
     * @param $merchantURL
     * @param $urlOK
     * @param $urlKO
     * @param $merchantName
     * @param array $merchantData
     * @param string $currency
     * @param string $consumerLanguage
     * @param int $terminal
     * @param int $transactionType
     * @param string $payMethods
     */
    public function __construct(
        $amount,
        $productDescription,
        $titular,
        $merchantCode,
        $merchantURL,
        $urlOK,
        $urlKO,
        $merchantName,
        $merchantData = [],
        $currency = RedSysCurrency::EURO_CURRENCY,
        $consumerLanguage = RedSysLang::SPANISH,
        $terminal = RedSysConfig::TERMINAL,
        $transactionType = RedSysConfig::TRANSACTION_TYPE,
        $payMethods = RedSysPayMethods::CREDIT_CARD
    ) {
        $this->amount = $amount;
        $this->productDescription = $productDescription;
        $this->titular = $titular;
        $this->merchantCode = $merchantCode;
        $this->merchantURL = $merchantURL;
        $this->urlOK = $urlOK;
        $this->urlKO = $urlKO;
        $this->merchantName = $merchantName;
        $this->merchantData = $merchantData;
        $this->currency = $currency;
        $this->consumerLanguage = $consumerLanguage;
        $this->terminal = $terminal;
        $this->transactionType = $transactionType;
        $this->payMethods = $payMethods;
        $this->order = date('ymdmis');
    }

    /**
     * @return mixed
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @return mixed
     */
    public function getOrder()
    {
        return $this->order;
    }

    /**
     * @return mixed
     */
    public function getProductDescription()
    {
        return $this->productDescription;
    }

    /**
     * @return mixed
     */
    public function getTitular()
    {
        return $this->titular;
    }

    /**
     * @return mixed
     */
    public function getMerchantCode()
    {
        return $this->merchantCode;
    }

    /**
     * @return mixed
     */
    public function getMerchantURL()
    {
        return $this->merchantURL;
    }

    /**
     * @return mixed
     */
    public function getUrlOK()
    {
        return $this->urlOK;
    }

    /**
     * @return mixed
     */
    public function getUrlKO()
    {
        return $this->urlKO;
    }

    /**
     * @return mixed
     */
    public function getMerchantName()
    {
        return $this->merchantName;
    }

    /**
     * @return array
     */
    public function getMerchantData()
    {
        return $this->merchantData;
    }

    /**
     * @return string
     */
    public function getConsumerLanguage()
    {
        return $this->consumerLanguage;
    }

    /**
     * @return int
     */
    public function getTerminal()
    {
        return $this->terminal;
    }

    /**
     * @return int
     */
    public function getTransactionType()
    {
        return $this->transactionType;
    }

    /**
     * @return mixed
     */
    public function getPayMethods()
    {
        return $this->payMethods;
    }

    /**
     * @param $amount
     * @param $productDescription
     * @param $titular
     * @param $merchantCode
     * @param $merchantURL
     * @param $urlOK
     * @param $urlKO
     * @param $merchantName
     * @param array $merchantData
     * @param string $currency
     * @param string $consumerLanguage
     * @param int $terminal
     * @param int $transactionType
     * @param string $payMethods
     *
     * @return Transaction
     */
    public static function createInstance(
        $amount,
        $productDescription,
        $titular,
        $merchantCode,
        $merchantURL,
        $urlOK,
        $urlKO,
        $merchantName,
        $merchantData = [],
        $currency = RedSysCurrency::EURO_CURRENCY,
        $consumerLanguage = RedSysLang::SPANISH,
        $terminal = RedSysConfig::TERMINAL,
        $transactionType = RedSysConfig::TRANSACTION_TYPE,
        $payMethods = RedSysPayMethods::CREDIT_CARD
    ) {
        return new self(
            $amount,
            $productDescription,
            $titular,
            $merchantCode,
            $merchantURL,
            $urlOK,
            $urlKO,
            $merchantName,
            $merchantData,
            $currency,
            $consumerLanguage,
            $terminal,
            $transactionType,
            $payMethods
        );
    }
}