<?php

namespace Comitium5\PaymentBundle\Payments\RedSys;

/**
 * Class RedSysTemplatingService
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Payments\RedSys
 */
class RedSysTemplatingService
{
    /**
     * @var \Twig_Environment
     */
    protected $templating;

    /**
     * RedSysTemplatingService constructor.
     *
     * @param \Twig_Environment $templating
     */
    public function __construct(\Twig_Environment $templating)
    {
        $this->templating = $templating;
    }

    /**
     * @param $data
     * @param string $template
     *
     * @return string
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     */
    public function render($data, $template = '@Comitium5Payment/RedSys/request.html.twig')
    {
        return $this->templating->render($template, $data);
    }
}