<?php

namespace Comitium5\PaymentBundle\Components\Interfaces;

/**
 * Interface RedSysTransactionInterface
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Interfaces
 */
interface RedSysTransactionInterface extends TransactionInterface
{
    /**
     * @return mixed
     */
    public function getOrder();

    /**
     * @return mixed
     */
    public function getProductDescription();

    /**
     * @return mixed
     */
    public function getTitular();

    /**
     * @return mixed
     */
    public function getMerchantCode();

    /**
     * @return mixed
     */
    public function getMerchantURL();

    /**
     * @return mixed
     */
    public function getUrlOK();

    /**
     * @return mixed
     */
    public function getUrlKO();

    /**
     * @return mixed
     */
    public function getMerchantName();

    /**
     * @return array
     */
    public function getMerchantData();

    /**
     * @return string
     */
    public function getConsumerLanguage();

    /**
     * @return int
     */
    public function getTerminal();

    /**
     * @return int
     */
    public function getTransactionType();

    /**
     * @return mixed
     */
    public function getPayMethods();
}