<?php

namespace Comitium5\PaymentBundle\Payments\RedSys;

use Comitium5\PaymentBundle\Components\Helpers\RedSys\RedSysHelper;
use Comitium5\PaymentBundle\Components\Interfaces\RedSysTransactionInterface;
use Comitium5\PaymentBundle\Components\Validators\RedSys\RedSysServiceValidator;
use Comitium5\PaymentBundle\Components\ValueObjects\PaymentObject;

/**
 * Class RedSysPaymentService
 *
 * @author David Carrascosa <david@bab-soft.com>
 * @package Comitium5\PaymentBundle\Payments\RedSys
 */
class RedSysPaymentService
{
    /**
     * @var RedSysTemplatingService
     */
    protected $templating;

    /**
     * @var string
     */
    protected $endPoint;

    /**
     * @var string
     */
    protected $privateKey;

    /**
     * @var string
     */
    protected $fuc;

    /**
     * RedSysPaymentService constructor.
     *
     * @param RedSysTemplatingService $templating
     * @param string $endPoint
     * @param string|null $privateKey
     * @param string|null $fuc
     */
    public function __construct(RedSysTemplatingService $templating, $endPoint, $privateKey = null, $fuc = null)
    {
        $this->templating = $templating;
        $this->privateKey = $privateKey;
        $this->fuc        = $fuc;
        $this->endPoint   = $endPoint;
    }

    /**
     * @param RedSysTransactionInterface $transaction
     *
     * @return PaymentObject
     * @throws \Twig_Error_Loader
     * @throws \Twig_Error_Runtime
     * @throws \Twig_Error_Syntax
     * @throws \Exception
     */
    public function pay(RedSysTransactionInterface $transaction)
    {
        RedSysServiceValidator::validate(
            $this->getPrivateKey(),
            $this->getFuc()
        );

        $formParameters = RedSysHelper::generateFormParameters($transaction, $this->privateKey);

        return new PaymentObject(
            $this->templating->render([
                'tpvUrl' => $this->endPoint,
                'params' => $formParameters,
            ])
        );
    }

    /**
     * @return string
     */
    public function getPrivateKey()
    {
        return $this->privateKey;
    }

    /**
     * @return string
     */
    public function getFuc()
    {
        return $this->fuc;
    }

    /**
     * @param null $privateKey
     * @param null $fuc
     */
    public function build($privateKey = null, $fuc = null)
    {
        $this->privateKey = $privateKey;
        $this->fuc = $fuc;
    }
}