<?php

namespace Comitium5\PaymentBundle\Payments\RedSys;

use Comitium5\PaymentBundle\Components\Helpers\RedSys\RedSysHelper;
use Comitium5\PaymentBundle\Components\Interfaces\PaymentInterface;
use Comitium5\PaymentBundle\Components\Interfaces\RedSysTransactionInterface;
use Comitium5\PaymentBundle\Components\Interfaces\TransactionInterface;
use Comitium5\PaymentBundle\Components\Validators\RedSys\RedSysServiceValidator;
use Comitium5\PaymentBundle\Components\Interfaces\PaymentClientInterface;
use Comitium5\PaymentBundle\Payments\Client\RedSysHttpClientService;
use Comitium5\PaymentBundle\Components\ValueObjects\PaymentObject;

/**
 * Class RedSysBackgroundPaymentService
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Payments\RedSys
 */
class RedSysBackgroundPaymentService implements PaymentInterface
{
    /**
     * @var RedSysHttpClientService
     */
    protected $clientService;

    /**
     * @var string
     */
    protected $endPoint;

    /**
     * @var string
     */
    protected $privateKey;

    /**
     * @var string
     */
    protected $fuc;

    /**
     * RedSysNoInteractionPaymentService constructor.
     *
     * @param PaymentClientInterface $clientService
     * @param string $endPoint
     * @param null|string $privateKey
     * @param null|string $fuc
     */
    public function __construct(PaymentClientInterface $clientService, $endPoint, $privateKey = null, $fuc = null)
    {
        $this->clientService = $clientService;
        $this->endPoint      = $endPoint;
        $this->privateKey    = $privateKey;
        $this->fuc           = $fuc;
    }

    /**
     * @param TransactionInterface $transaction
     *
     * @return PaymentObject|mixed
     * @throws \Exception
     */
    public function pay(TransactionInterface $transaction)
    {
        if (!($transaction instanceof RedSysTransactionInterface)) {
            throw new \Exception("Transaction must be instance of RedSysTransactionInterface");
        }

        RedSysServiceValidator::validate(
            $this->privateKey,
            $this->fuc
        );

        $formParameters = RedSysHelper::generateFormParameters($transaction, $this->privateKey);

        return new PaymentObject(
            $this
                ->clientService
                ->pay($this->endPoint, $formParameters)
        );
    }


}
