<?php

namespace Comitium5\PaymentBundle\Components\Model\Stripe;

use Comitium5\PaymentBundle\Components\Interfaces\CardInterface;
use Comitium5\PaymentBundle\Components\Interfaces\StripeTransactionInterface;
use Stripe\Customer;

/**
 * Class Transaction
 *
 * @author Daniel J. Pérez <danieljordi@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Model\Stripe
 */
class Transaction implements StripeTransactionInterface
{
    /**
     * @var CardInterface
     */
    protected $card;

    /**
     * @var float
     */
    protected $amount;

    /**
     * @var string
     */
    protected $currency;

    /**
     * @var array
     */
    protected $metadata = [];

    /**
     * @var Customer
     */
    protected $customer = null;

    /**
     * @return CardInterface
     */
    public function getCard()
    {
        return $this->card;
    }

    /**
     * @param CardInterface $card
     * @return StripeTransactionInterface
     */
    public function setCard(CardInterface $card)
    {
        $this->card = $card;

        return $this;
    }

    /**
     * @return float
     */
    public function getAmount()
    {
        return $this->amount;
    }

    /**
     * @param float $amount
     * @return $this
     */
    public function setAmount($amount)
    {
        $this->amount = $amount;

        return $this;
    }

    /**
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }

    /**
     * @param string $currency
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;

        return $this;
    }

    /**
     * @return array
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * @param array $metadata
     * @return $this
     */
    public function setMetadata(array $metadata)
    {
        $this->metadata = $metadata;

        return $this;
    }

    /**
     * @return Customer
     */
    public function getCustomer()
    {
        return $this->customer;
    }

    /**
     * @param Customer $customer
     * @return $this
     */
    public function setCustomer(Customer $customer)
    {
        $this->customer = $customer;

        return $this;
    }

}