<?php

namespace Comitium5\PaymentBundle\Components\Factories;

use Comitium5\PaymentBundle\Components\Interfaces\FactoryInterface;

/**
 * Class AbstractFactory
 *
 * @author Daniel J. Pérez <danieljordi@bab-soft.com>
 * @package Comitium5\PaymentBundle\Components\Factories
 */
abstract class AbstractFactory implements FactoryInterface
{
    /**
     * @var string
     */
    protected $namespace;

    /**
     * @return mixed
     */
    abstract public function create();

    /**
     * @return string
     */
    public function getNamespace()
    {
        return $this->namespace;
    }

    /**
     * @param string $namespace
     * @return $this
     */
    public function setNamespace($namespace)
    {
        $this->namespace = $namespace;

        return $this;
    }
}