<?php

namespace Comitium5\MailingBundle\Event;

use Comitium5\MailingBundle\Model\Campaign\CampaignInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Class CampaignEvent
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Event
 */
class CampaignEvent extends Event
{
    /**
     * string
     */
    const PRE_SEND = "comitium5_mailing.event.campaign.pre_send";

    /**
     * string
     */
    const POST_SEND = "comitium5_mailing.event.campaign.post_send";

    /**
     * @var CampaignInterface
     */
    protected $campaign;

    /**
     * @var mixed
     */
    protected $result;

    /**
     * @var array
     */
    protected $failedRecipients;

    /**
     * CampaignEvent constructor.
     * @param CampaignInterface $campaign
     * @param $result
     * @param $failedRecipients
     */
    public function __construct(
        CampaignInterface $campaign,
        $result,
        $failedRecipients
    )
    {
        $this->campaign = $campaign;
        $this->result = $result;
        $this->failedRecipients = $failedRecipients;
    }

    /**
     * @return CampaignInterface
     */
    public function getCampaign()
    {
        return $this->campaign;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return array
     */
    public function getFailedRecipients()
    {
        return $this->failedRecipients;
    }
}