<?php

namespace Comitium5\MailingBundle\Entity;

use Comitium5\MailingBundle\Model\BouncedList\BouncedListInterface;
use Comitium5\MailingBundle\Model\Campaign\CampaignInterface;
use Comitium5\MailingBundle\Model\Core\DateTimeTrait;
use Comitium5\MailingBundle\Model\Core\EmailCampaignTrait;

/**
 * Class BouncedList
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Entity
 */
class BouncedList implements BouncedListInterface
{
    use EmailCampaignTrait,
        DateTimeTrait;

    /**
     * @var string
     */
    protected $code;

    /**
     * @var string
     */
    protected $message;

    /**
     * BouncedList constructor.
     * @param CampaignInterface $campaign
     * @param $email
     * @param null $code
     * @param null $message
     */
    public function __construct(
        CampaignInterface $campaign,
        $email,
        $code = null,
        $message = null
    )
    {
        $this->campaign = $campaign;
        $this->email = $email;
        $this->code = $code;
        $this->message = $message;
        $this->createdDate = new \DateTime();
    }

    /**
     * @return string
     */
    public function getCode()
    {
        return $this->code;
    }

    /**
     * @param string $code
     * @return $this
     */
    public function setCode($code)
    {
        $this->code = $code;

        return $this;
    }

    /**
     * @return string
     */
    public function getMessage()
    {
        return $this->message;
    }

    /**
     * @param string $message
     * @return $this
     */
    public function setMessage($message)
    {
        $this->message = $message;

        return $this;
    }
}