<?php

namespace Comitium5\MailingBundle\Services\Builder;

use Comitium5\MailingBundle\Services\Message;
use Comitium5\MailingBundle\Services\MessageInterface;

/**
 * Class MessageBuilder
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\MailingBundle\Services\Builder
 */
class MessageBuilder
{
    /**
     * @param string $from
     * @param array $recipients
     * @param string $subject
     * @param string $body
     *
     * @return MessageInterface
     */
    public function build(
        string $from,
        array $recipients,
        string $subject,
        string $body
    ): MessageInterface {
        $message = new Message($subject, $body, "text/html");

        $message
            ->setFrom($from)
            ->setTo($recipients);

        return $message;
    }
}
