<?php

namespace Comitium5\MailingBundle\Services\Parser;

/**
 * Class BounceCode
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Parser
 */
class BounceCode
{
    /**
     * All known bounce codes with their explanation
     *
     * @see http://help.pardot.com/customer/portal/articles/2128156-bounce-codes-reference
     * @var array
     */
    private static $codes = [
        'No reason found',
        "421" => "service not available, closing transmission channel (this may be a reply to any command if the service knows it must shut down)",
        "450" => "requested mail action not taken: mailbox unavailable (e.g., mailbox busy or temporarily blocked for policy reasons)",
        "451" => "requested action aborted: local error in processing",
        "452" => "requested action not taken: insufficient system storage",
        "455" => "server unable to accommodate parameters",
        "500" => "syntax error, command unrecognized (this may include errors such as an overlong command line)",
        "501" => "syntax error in parameters or arguments",
        "502" => "command not implemented",
        "503" => "bad sequence of commands",
        "504" => "command parameter not implemented",
        "550" => "requested action not taken: mailbox unavailable (eg. mailbox not found, no access, or command rejected for policy reasons)",
        "551" => "user not local; please try",
        "552" => "requested mail action aborted: exceeded storage allocation",
        "553" => "requested action not taken: mailbox name not allowed (e.g., mailbox syntax incorrect)",
        "554" => "transaction failed (or, in the case of a connectionopening response, no SMTP service here)",
        "555" => "MAIL FROM/RCPT TO parameters not recognized or not implemented",
        "5.0.0" => "Unknown issue",
        "5.1.0" => "Other address status",
        "5.1.1" => "Bad destination mailbox address",
        "5.1.2" => "Bad destination system address",
        "5.1.3" => "Bad destination mailbox address syntax",
        "5.1.4" => "Destination mailbox address ambiguous",
        "5.1.5" => "Destination mailbox address valid",
        "5.1.6" => "Mailbox has moved",
        "5.1.7" => "Bad sender's mailbox address syntax",
        "5.1.8" => "Bad sender's system address",
        "5.2.0" => "Other or undefined mailbox status",
        "5.2.1" => "Mailbox disabled, not accepting messages",
        "5.2.2" => "Mailbox full",
        "5.2.3" => "Message length exceeds administrative limit.",
        "5.2.4" => "Mailing list expansion problem",
        "5.3.0" => "Other or undefined mail system status",
        "5.3.1" => "Mail system full",
        "5.3.2" => "System not accepting network messages",
        "5.3.3" => "System not capable of selected features",
        "5.3.4" => "Message too big for system",
        "5.4.0" => "Other or undefined network or routing status",
        "5.4.1" => "No answer from host",
        "5.4.2" => "Bad connection",
        "5.4.3" => "Routing server failure",
        "5.4.4" => "Unable to route",
        "5.4.5" => "Network congestion",
        "5.4.6" => "Routing loop detected",
        "5.4.7" => "Delivery time expired",
        "5.5.0" => "Other or undefined protocol status",
        "5.5.1" => "Invalid command",
        "5.5.2" => "Syntax error",
        "5.5.3" => "Too many recipients",
        "5.5.4" => "Invalid command arguments",
        "5.5.5" => "Wrong protocol version",
        "5.6.0" => "Other or undefined media error",
        "5.6.1" => "Media not supported",
        "5.6.2" => "Conversion required and prohibited",
        "5.6.3" => "Conversion required but not supported",
        "5.6.4" => "Conversion with loss performed",
        "5.6.5" => "Conversion failed",
        "5.7.0" => "Other or undefined security status",
        "5.7.1" => "Delivery not authorized, message refused",
        "5.7.2" => "Mailing list expansion prohibited",
        "5.7.3" => "Security conversion required but not possible",
        "5.7.4" => "Security features not supported",
        "5.7.5" => "Cryptographic failure",
        "5.7.6" => "Cryptographic algorithm not supported",
        "5.7.7" => "Message integrity failure",
    ];

    /**
     * @param $content
     * @param $errorCode
     * @param $errorMessage
     */
    public static function getCode($content, &$errorCode, &$errorMessage)
    {
        $errorCode = null;
        $errorMessage = self::$codes[0];

        if (preg_match_all('/[0-9]\.?[0-9]\.?[0-9]/m', $content, $matches) > 0) {
            $matches = array_reverse($matches[0]);

            foreach ($matches as $match) {
                if (array_key_exists($match, self::$codes)) {
                    $errorCode = $match;
                    $errorMessage = self::$codes[$match];
                    break;
                }
            }
        }
    }
}
