<?php

namespace Comitium5\MailingBundle\Entity;

use Comitium5\MailingBundle\Model\Campaign\CampaignStatsInterface;
use Comitium5\MailingBundle\Model\Campaign\CampaignStatValue;
use Comitium5\MailingBundle\Model\Core\DateTimeTrait;
use Comitium5\MailingBundle\Model\Core\EmailCampaignTrait;
use Comitium5\MailingBundle\Model\Core\IdentifiableTrait;

/**
 * Class CampaignStats
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Entity
 */
class CampaignStats implements CampaignStatsInterface
{
    use IdentifiableTrait,
        EmailCampaignTrait,
        DateTimeTrait;

    /**
     * @var bool
     */
    protected $extraData;

    /**
     * @var bool
     */
    protected $open;

    /**
     * @var bool
     */
    protected $click;

    /**
     * @var bool
     */
    protected $bounced;

    /**
     * CampaignStats constructor.
     * @param CampaignStatValue $campaignStatValue
     */
    public function __construct(CampaignStatValue $campaignStatValue)
    {
        $this->compute($campaignStatValue);
        $this->createdDate = new \DateTime();
    }

    /**
     * @param CampaignStatValue $campaignStatValue
     * @return $this
     */
    public function compute(CampaignStatValue $campaignStatValue)
    {
        if ($campaignStatValue->getValue() === self::OPEN) {
            $this->open = true;
        } elseif ($campaignStatValue->getValue() === self::CLICK) {
            $this->click = true;
        } elseif ($campaignStatValue->getValue() === self::BOUNCED) {
            $this->bounced = true;
        }

        return $this;
    }

    /**
     * @param $extraData
     * @return $this
     */
    public function setExtraData($extraData)
    {
        if (is_array($extraData)) {
            $extraData = json_encode($extraData);
        }

        $this->extraData = $extraData;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getExtraData()
    {
        return $this->extraData;
    }
}