<?php

namespace Comitium5\MailingBundle\Services\Reader;

/**
 * Interface MailReaderInterface
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Reader
 */
interface MailReaderInterface
{
    /**
     * @return $this
     */
    public function read(): MailReaderInterface;

    /**
     * @return array
     */
    public function getOverviews();

    /**
     * @return array
     */
    public function getHeaders();

    /**
     * @return array
     */
    public function getBodies();

    /**
     * @param $criteria
     * @return mixed
     */
    public function setCriteria($criteria);

    /**
     * @return mixed
     */
    public function getCriteria();

    /**
     * @return bool
     */
    public function hasErrors(): bool;

    /**
     * @return array
     */
    public function getErrors(): array;
}
