<?php

namespace Comitium5\MailingBundle\Services\Reader;

/**
 * Class ImapReader
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Reader
 */
class ImapReader extends AbstractImap
{
    /**
     * @var array|false
     */
    protected $imapErrors;

    /**
     * @var array|false
     */
    protected $imapAlerts;

    /**
     * @return $this|mixed
     */
    public function read(): MailReaderInterface
    {
        $inbox = $this->openImapConection();

        if ($inbox === false) {
            return $this;
        }

        $emails = imap_search($inbox, $this->criteria);

        if (!empty($emails)) {

            rsort($emails);

            foreach ($emails as $emailIndex) {
                $overviews = imap_fetch_overview($inbox, $emailIndex, 0);
                $body = imap_body($inbox, $emailIndex, 2);
                $header = imap_headerinfo($inbox, $emailIndex);

                imap_setflag_full($inbox, $emailIndex, "\\Seen");

                if (!empty($overviews[0])) {
                    $this->overviews[$emailIndex] = $overviews[0];
                }

                if (!empty($body)) {
                    $this->bodies[$emailIndex] = $body;
                }

                if (!empty($header)) {
                    $this->headers[$emailIndex] = $header;
                }
            }
        }

        imap_close($inbox);

        return $this;
    }

    /**
     *
     */
    protected function openImapConection()
    {
        $inbox = @imap_open($this->host, $this->user, $this->password);

        $imapErrors = imap_errors();

        // Adding errors and alerts prevents fatal error on execution
        $this->imapErrors = is_array($imapErrors) ? $imapErrors : [];
        $this->imapAlerts = imap_alerts();

        return $inbox;
    }

    /**
     * @return bool
     */
    public function hasErrors(): bool
    {
        return count($this->imapErrors) > 0;
    }

    /**
     * @return array
     */
    public function getErrors(): array
    {
        return $this->imapErrors;
    }
}
