<?php

namespace Comitium5\MailingBundle\Manager;

use Comitium5\MailingBundle\Model\Campaign\CampaignInterface;
use Comitium5\MailingBundle\Repository\AbstractRepository;
use Comitium5\MailingBundle\Repository\CampaignRepository;

/**
 * Class CampaignManager
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Manager
 */
class CampaignManager implements ManagerInterface
{
    /**
     * @var CampaignRepository
     */
    private $campaignRepository;

    /**
     * CampaignManager constructor.
     * @param AbstractRepository $repository
     */
    public function __construct(AbstractRepository $repository)
    {
        $this->campaignRepository = $repository;
    }

    /**
     * @return CampaignRepository
     */
    public function getRepository()
    {
        return $this->campaignRepository;
    }

    /**
     * @param CampaignInterface $campaign
     */
    public function save(CampaignInterface $campaign)
    {
        $this
            ->campaignRepository
            ->save($campaign);
    }
}