<?php

namespace Comitium5\MailingBundle\Services\Parser;

use Comitium5\MailingBundle\Services\Bounced\BouncedCommand;
use Comitium5\MailingBundle\Services\Builder\CampaignMessageBuilder;
use Comitium5\MailingBundle\Services\Reader\MailReaderInterface;

/**
 * Class BouncedParser
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Parser
 */
class BouncedParser implements ParserInterface
{
    /**
     * @param $data
     * @return BouncedCommand[]
     * @throws \Exception
     */
    public function parse($data)
    {
        if (!$data instanceof MailReaderInterface) {
            throw new \Exception("Data must be an instance of MailReaderInterface");
        }

        $parsedData = [];

        foreach ($data->getBodies() as $body) {
            $bodyStartPos = strpos($body, "<html");

            $bodyToGetErrorCode = $bodyStartPos ? substr($body, 0, $bodyStartPos) : $body;

            $campaignId = null;
            $email = null;
            $errorCode = null;
            $errorMessage = null;

            BounceCode::getCode($bodyToGetErrorCode, $errorCode, $errorMessage);

            preg_match("/".CampaignMessageBuilder::HEADER_CAMPAIGN.":(.+)/", $body, $matches);

            if (!empty($matches[1])) {
                $campaignId = $matches[1];
            }

            preg_match("/".CampaignMessageBuilder::HEADER_EMAIL.":(.+)/", $body, $matches);

            if (!empty($matches[1])) {
                $email = $matches[1];
            }

            $parsedData[] = new BouncedCommand(
                trim($campaignId),
                trim($email),
                $errorCode,
                $errorMessage
            );
        }

        return $parsedData;
    }
}
