<?php

namespace Comitium5\MailingBundle\Event;

use Symfony\Component\EventDispatcher\Event;

/**
 * Class ErrorEmailEvent
 *
 * @author Carles Gómez <carles@bab-soft.com>
 * @package Comitium5\MailingBundle\Event
 */
class ErrorEmailEvent extends Event
{
    const ON_IMAP_ERROR = "comitium5_mailing.event.bounced_email.on_imap_error";

    /**
     * @var array
     */
    protected $imapErrors;

    /**
     * ErrorEmailEvent constructor.
     *
     * @param $imapErrors
     */
    public function __construct(array $imapErrors)
    {
        $this->imapErrors = $imapErrors;
    }

    /**
     * @return array
     */
    public function getImapErrors(): array
    {
        return $this->imapErrors;
    }
}
