<?php

namespace Comitium5\MailingBundle\Tests\Services\Dispatcher;

use Comitium5\MailingBundle\Entity\Campaign;
use Comitium5\MailingBundle\Manager\CampaignManager;
use Comitium5\MailingBundle\Services\Builder\CampaignMessageBuilder;
use Comitium5\MailingBundle\Services\Dispatcher\CampaignDispatcher;
use Comitium5\MailingBundle\Services\Message;
use Comitium5\MailingBundle\Services\Parser\CampaignContentParser;
use Comitium5\MailingBundle\Services\Sender\SmtpSender;
use PHPUnit\Framework\TestCase;
use Symfony\Component\EventDispatcher\EventDispatcher;

/**
 * Class CampaignDispatcherTest
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Tests\Services\Dispatcher
 */
class CampaignDispatcherTest extends TestCase
{
    /**
     * @dataProvider expected
     * @throws \Exception
     */
    public function testDispatch($iterations, $expected, $setLimit)
    {
        $sender = $this
            ->getMockBuilder(SmtpSender::class)
            ->disableOriginalConstructor()
            ->getMock();

        $parser = $this
            ->getMockBuilder(CampaignContentParser::class)
            ->disableOriginalConstructor()
            ->getMock();

        $manager = $this
            ->getMockBuilder(CampaignManager::class)
            ->disableOriginalConstructor()
            ->getMock();

        $builder = $this
            ->getMockBuilder(CampaignMessageBuilder::class)
            ->setConstructorArgs(array("parser" => $parser, "returnPath" => "foo@bar.com"))
            ->getMock()
        ;

        $sender
            ->expects($this->any())
            ->method("send")
            ->will($this->returnValue(1));

        $message = new Message();

        $message
            ->setSubject("Foo")
            ->setTo("foo@bar.com")
            ->setReturnPath("boucer@foo.com")
            ->setBody("Foo body");

        $campaign = new Campaign("Foo", "Subject for testing", array("admin@foo.bar" => "Admin"), "foo bar content");

        for ($x=0; $x<$iterations; $x++) {
            $campaign->addMailingList("foo{$x}@foo.com", array("@name@" => "Foo", "@surname@" => "Foo's surname"));
        }

        $builder
            ->expects($this->any())
            ->method("build")
            ->willReturn($message);

        $dispatcher = $this
            ->getMockBuilder(EventDispatcher::class)
            ->disableOriginalConstructor()
            ->getMock();

        $dispatcher = new CampaignDispatcher($sender, $dispatcher, $builder, $manager);

        if ($setLimit === true) {
            $dispatcher->setLimit($expected);
        }

        $result = $dispatcher->dispatch($campaign);

        $this->assertEquals($result->getResult(), $expected);
        $this->assertEquals($result->getCampaign()->getMailingLists()->count(), ($iterations-$expected));
    }

    /**
     * @return array
     */
    public function expected()
    {
        return array(
            array(100,100, false),
            array(100,25, true),
        );
    }
}