<?php

namespace Comitium5\MailingBundle\Entity;

use Comitium5\MailingBundle\Model\Core\DateTimeTrait;
use Comitium5\MailingBundle\Model\Core\EmailCampaignTrait;
use Comitium5\MailingBundle\Model\MailingList\MailingListInterface;

/**
 * Class MailingList
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Model
 */
class MailingList implements MailingListInterface
{
    use EmailCampaignTrait, DateTimeTrait;

    /**
     * @var array
     */
    protected $replacements;

    /**
     * @var bool
     */
    protected $blocked;

    /**
     * MailingList constructor.
     */
    public function __construct()
    {
        $this->blocked = false;
    }

    /**
     * @return array
     */
    public function getReplacements()
    {
        return $this->replacements;
    }

    /**
     * @param array $replacements
     * @return $this
     */
    public function setReplacements($replacements)
    {
        $this->replacements = $replacements;

        return $this;
    }

    /**
     * @return bool|mixed
     */
    public function isBlocked()
    {
        return $this->blocked;
    }

    /**
     * @param $blocked
     * @return $this|mixed
     */
    public function setBlocked($blocked)
    {
        $this->blocked  =$blocked;

        return $this;
    }
}