<?php

namespace Comitium5\MailingBundle\Controller;

use Comitium5\MailingBundle\Model\Campaign\CampaignInterface;
use Comitium5\MailingBundle\Repository\CampaignRepository;
use Comitium5\MailingBundle\Services\Parser\CampaignContentParser;
use Comitium5\MailingBundle\Services\Stats\CampaignStatsComputer;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\Exception\BadRequestHttpException;

/**
 * Class ComputeStats
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Controller
 */
class ComputeStatsController
{
    /**
     * @var CampaignRepository
     */
    protected $campaignRepository;

    /**
     * @var CampaignStatsComputer
     */
    protected $statsComputer;

    /**
     * ComputeStatsController constructor.
     * @param CampaignRepository $campaignRepository
     * @param CampaignStatsComputer $statsComputer
     */
    public function __construct(
        CampaignRepository $campaignRepository,
        CampaignStatsComputer $statsComputer
    ) {
        $this->campaignRepository = $campaignRepository;
        $this->statsComputer      = $statsComputer;
    }

    /**
     * @return RedirectResponse
     */
    public function computeClickAction()
    {
        $request = Request::createFromGlobals();

        $data = $request->get(CampaignContentParser::ENCODE_PARAM);
        $data = CampaignContentParser::decode($data);

        if (
            empty($data[CampaignContentParser::REDIRECT_PARAM]) ||
            empty($data[CampaignContentParser::EMAIL_PARAM]) ||
            empty($data[CampaignContentParser::CAMPAIGN_ID_PARAM])
        )
        {
            throw new BadRequestHttpException();
        }

        $campaign = $this
            ->campaignRepository
            ->find($data[CampaignContentParser::CAMPAIGN_ID_PARAM]);

        if (!$campaign instanceof CampaignInterface) {
            throw new BadRequestHttpException("Invalid campaign identifier");
        }

        $extraData = empty($data[CampaignContentParser::EXTRA_DATA_PARAM]) ? null : $data[CampaignContentParser::EXTRA_DATA_PARAM];

        $this
            ->statsComputer
            ->computeClick($campaign, $data[CampaignContentParser::EMAIL_PARAM], $extraData);

        return new RedirectResponse($data[CampaignContentParser::REDIRECT_PARAM]);
    }

    /**
     * @return Response
     */
    public function computeOpenAction()
    {
        $request = Request::createFromGlobals();

        $data = $request->get(CampaignContentParser::ENCODE_PARAM);
        $data = CampaignContentParser::decode($data);

        if (
            empty($data[CampaignContentParser::EMAIL_PARAM]) ||
            empty($data[CampaignContentParser::CAMPAIGN_ID_PARAM])
        )
        {
            throw new BadRequestHttpException();
        }

        $campaign = $this
            ->campaignRepository
            ->find($data[CampaignContentParser::CAMPAIGN_ID_PARAM]);

        if (!$campaign instanceof CampaignInterface) {
            throw new BadRequestHttpException("Invalid campaign identifier");
        }

        $extraData = empty($data[CampaignContentParser::EXTRA_DATA_PARAM]) ? null : $data[CampaignContentParser::EXTRA_DATA_PARAM];

        $this
            ->statsComputer
            ->computeOpen($campaign, $data[CampaignContentParser::EMAIL_PARAM], $extraData);

        return new Response("", Response::HTTP_OK, array("content-type" => "text/css"));
    }
}