<?php

namespace Comitium5\MailingBundle\Command;

use Comitium5\MailingBundle\Entity\MailingList;
use Symfony\Bundle\FrameworkBundle\Command\ContainerAwareCommand;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;

/**
 * Class CampaignSenderCommand
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Command
 */
class SendThreadCommand extends ContainerAwareCommand
{
    /**
     * {@inheritdoc}
     */
    protected function configure()
    {
        $this
            ->setName('comitium5_mailing:campaign:send-thread')
            ->setDescription('Send campaigns')
            ->addOption("thread", null, InputOption::VALUE_REQUIRED)
            ->addOption("data", null, InputOption::VALUE_REQUIRED)
            ->addOption("delete", null, InputOption::VALUE_REQUIRED, "Delete mailing list item after email is sended", true)
        ;
    }

    /**
     * @param InputInterface $input
     * @param OutputInterface $output
     * @throws \Exception
     * @return void
     */
    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $data   = json_decode($input->getOption("data"), true);
        $thread = $input->getOption("thread");
        $delete = $input->getOption("delete");

        $container              = $this->getContainer();
        $campaignDispatcher     = $container->get("comitium5_mailing.dispatcher.campaign");
        $campaignDispatcher->setRootDir($container->getParameter("kernel.root_dir"));

        foreach ($data as $item) {

            $mailingList = $this->findMailingList($item["campaignId"], $item["email"]);

            if (!$mailingList) {
                continue;
            }

            try {
                $response = $campaignDispatcher->dispatchMailingList($mailingList, $thread);
                if ($response->getResult() === 1 && $delete) {
                    $this->delete($mailingList);
                }
            } catch (\Exception $e) {
                $this->delete($mailingList);
            }
        }
    }

    /**
     * @param $campaignId
     * @param $email
     * @return MailingList|null
     */
    private function findMailingList($campaignId, $email)
    {
        return $this
            ->getContainer()
            ->get("comitium5_mailing.repository.mailing_list")
            ->findOneBy([
                "campaign" => $campaignId,
                "email"    => $email
            ]);
    }

    /**
     * @param MailingList $mailingList
     * @return mixed
     */
    private function delete(MailingList $mailingList)
    {
        return $this
            ->getContainer()
            ->get("comitium5_mailing.repository.mailing_list")
            ->remove($mailingList);
    }
}