<?php

namespace Comitium5\MailingBundle\Tests\Model;

use Comitium5\MailingBundle\Entity\Campaign;
use PHPUnit\Framework\TestCase;

/**
 * Class CampaignTest
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Tests\Model
 */
class CampaignTest extends TestCase
{
    /**
     * @expectedException \RunTimeException
     */
    public function testTestAbInstanceException()
    {
        Campaign::createTestABInstances("string_value","Foo", "bar", "foo@bar.com", "some content");
    }

    /**
     *
     */
    public function testTestAbInstance()
    {
        $instances = Campaign::createTestABInstances(3, "Foo", "bar", "foo@bar.com", "some content");

        $this->assertEquals(3, count($instances));
    }

    /**
     *
     */
    public function testCreateMessage()
    {
        $instance = new Campaign("Foo", "Subject test", array("foo@bar.com" => "Foo"), "some content");

        $instance->setContent("Foo bar");

        $message = $instance->createMessage();

        $this->assertEquals($message->getFrom(), array("foo@bar.com" => "Foo"));
        $this->assertEquals($message->getSubject(), "Subject test");
        $this->assertEquals($message->getBody(), "Foo bar");
    }

    /**
     *
     */
    public function testCreateInstance()
    {
        $instance = new Campaign("Foo", "Subject test", array("foo@bar.com" => "Foo"), "some content");
        $this->assertEquals($instance->getFromEmail(), "foo@bar.com");
        $this->assertEquals($instance->getFromName(), "Foo");

        $instance = new Campaign("Foo", "Subject test", "foo@bar.com", "some content");
        $this->assertEquals($instance->getFromEmail(), "foo@bar.com");
        $this->assertNull($instance->getFromName());
    }

    /**
     * @expectedException \Exception
     */
    public function testCreateInstanceException()
    {
        new Campaign("Foo", "Subject test", array("no_email" => "Foo"), "some content");
    }
}