<?php

namespace Comitium5\MailingBundle\Services\Stats;

use Comitium5\MailingBundle\Entity\CampaignStats;
use Comitium5\MailingBundle\Model\Campaign\CampaignInterface;
use Comitium5\MailingBundle\Model\Campaign\CampaignStatsInterface;
use Comitium5\MailingBundle\Model\Campaign\CampaignStatValue;
use Comitium5\MailingBundle\Repository\CampaignStatsRepository;

/**
 * Class CampaignStatsComputer
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Stats
 */
class CampaignStatsComputer
{
    /**
     * @var CampaignStatsRepository
     */
    protected $repository;

    /**
     * CampaignStatsComputer constructor.
     * @param CampaignStatsRepository $repository
     */
    public function __construct(CampaignStatsRepository $repository)
    {
        $this->repository = $repository;
    }

    /**
     * @param CampaignInterface $campaign
     * @param $email
     * @param null $extraData
     */
    public function computeClick(
        CampaignInterface $campaign,
        $email,
        $extraData = null
    ) {
        $instance = self::createInstance(
            new CampaignStatValue(CampaignStats::CLICK),
            $campaign,
            $email,
            $extraData
        );

        $this->persist($instance);
    }

    /**
     * @param CampaignInterface $campaign
     * @param $email
     * @param null $extraData
     */
    public function computeOpen(
        CampaignInterface $campaign,
        $email,
        $extraData = null
    ) {
        $instance = self::createInstance(
            new CampaignStatValue(CampaignStats::OPEN),
            $campaign,
            $email,
            $extraData
        );

        $this->persist($instance);
    }

    /**
     * @param CampaignInterface $campaign
     * @param $email
     * @param null $extraData
     */
    public function computeBounced(
        CampaignInterface $campaign,
        $email,
        $extraData = null
    ) {
        $instance = self::createInstance(
            new CampaignStatValue(CampaignStats::BOUNCED),
            $campaign,
            $email,
            $extraData
        );

        $this->persist($instance);
    }

    /**
     * @param CampaignStatValue $campaignStatValue
     * @param CampaignInterface $campaign
     * @param $email
     * @param null $extraData
     * @return CampaignStats
     */
    private static function createInstance(
        CampaignStatValue $campaignStatValue,
        CampaignInterface $campaign,
        $email,
        $extraData = null
    ) {
        $instance = new CampaignStats($campaignStatValue);

        $instance
            ->setCampaign($campaign)
            ->setEmail($email)
            ->setExtraData($extraData);

        return $instance;
    }

    /**
     * @param CampaignStatsInterface $instance
     */
    private function persist(CampaignStatsInterface $instance)
    {
        $this
            ->repository
            ->save($instance);
    }
}