<?php

namespace Comitium5\MailingBundle\Services\Response;

use Comitium5\MailingBundle\Model\Campaign\CampaignInterface;
use Comitium5\MailingBundle\Services\MessageInterface;

/**
 * Class CampaignResponse
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Response
 */
class CampaignResponse
{
    /**
     * @var CampaignInterface
     */
    protected $campaign;

    /**
     * @var mixed
     */
    protected $result;

    /**
     * @var array
     */
    protected $failedRecipients;

    /**
     * CampaignResponse constructor.
     * @param CampaignInterface $campaign
     * @param MessageInterface $message
     * @param mixed $result
     * @param array $failedRecipients
     */
    public function __construct(
        CampaignInterface $campaign,
        $result,
        array $failedRecipients
    ) {
        $this->campaign = $campaign;
        $this->result = $result;
        $this->failedRecipients = $failedRecipients;
    }

    /**
     * @return CampaignInterface
     */
    public function getCampaign()
    {
        return $this->campaign;
    }

    /**
     * @return mixed
     */
    public function getResult()
    {
        return $this->result;
    }

    /**
     * @return array
     */
    public function getFailedRecipients()
    {
        return $this->failedRecipients;
    }
}