<?php

namespace Comitium5\MailingBundle\Services\Reader;

/**
 * Class ImapReader
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Reader
 */
class ImapReader extends AbstractImap
{
    /**
     * @return $this
     * @throws \Exception
     */
    public function read()
    {
        $inbox = imap_open($this->host, $this->user, $this->password);

        if ($inbox === false) {
            throw new \Exception("Invalid imap connection. Double check your host, user and password.");
        }

        $emails = imap_search($inbox, $this->criteria);

        if (!empty($emails)) {

            rsort($emails);

            foreach ($emails as $emailIndex) {
                $overviews = imap_fetch_overview($inbox, $emailIndex, 0);
                $body = imap_body($inbox, $emailIndex, 2);
                $header = imap_headerinfo($inbox, $emailIndex);

                imap_setflag_full($inbox, $emailIndex, "\\Seen");

                if (!empty($overviews[0])) {
                    $this->overviews[$emailIndex] = $overviews[0];
                }

                if (!empty($body)) {
                    $this->bodies[$emailIndex] = $body;
                }

                if (!empty($header)) {
                    $this->headers[$emailIndex] = $header;
                }
            }
        }

        imap_close($inbox);

        return $this;
    }
}