<?php

namespace Comitium5\MailingBundle\Services\Reader;

use Comitium5\MailingBundle\Services\AuthenticatorMailTrait;

/**
 * Class AbstractImap
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Reader
 */
abstract class AbstractImap implements MailReaderInterface
{
    use AuthenticatorMailTrait;

    /**
     * @var array
     */
    protected $overviews;

    /**
     * @var array
     */
    protected $headers;

    /**
     * @var array
     */
    protected $bodies;

    /**
     * @var string
     */
    protected $criteria;

    /**
     * AbstractImap constructor.
     * @param $host
     * @param $user
     * @param $password
     * @param string $criteria
     */
    public function __construct(
        $host,
        $user,
        $password,
        $criteria = "UNSEEN"
    )
    {
        $this->host = $host;
        $this->user = $user;
        $this->password = $password;
        $this->overviews = array();
        $this->headers = array();
        $this->bodies = array();
        $this->criteria = $criteria;
    }

    /**
     * @return array
     */
    public function getOverviews()
    {
        return $this->overviews;
    }

    /**
     * @return array
     */
    public function getHeaders()
    {
        return $this->headers;
    }

    /**
     * @return array
     */
    public function getBodies()
    {
        return $this->bodies;
    }


    /**
     * @return string
     */
    public function getCriteria()
    {
        return $this->criteria;
    }

    /**
     * @param string $criteria
     * @return $this
     */
    public function setCriteria($criteria)
    {
        $this->criteria = $criteria;

        return $this;
    }
}