<?php

namespace Comitium5\MailingBundle\Services\Dispatcher;

use Comitium5\MailingBundle\Model\Campaign\CampaignInterface;
use Comitium5\MailingBundle\Model\MailingList\MailingListInterface;
use Comitium5\MailingBundle\Services\Sender\MailSenderInterface;

/**
 * Interface CampaignDispatcherInterface
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Services\Dispatcher
 */
interface CampaignDispatcherInterface
{
    /**
     * @param MailSenderInterface $sender
     * @return mixed
     */
    public function setSender(MailSenderInterface $sender);

    /**
     * @return MailSenderInterface
     */
    public function getSender();

    /**
     * @param CampaignInterface $campaign
     * @return mixed
     */
    public function dispatch(CampaignInterface $campaign);

    /**
     * @param MailingListInterface $mailingList
     * @return mixed
     */
    public function dispatchMailingList(MailingListInterface $mailingList);

    /**
     * @param int $limit
     * @return mixed
     */
    public function setLimit($limit);

    /**
     * @return int
     */
    public function getLimit();

    /**
     * @param bool $removeMailingListAfterSent
     * @return mixed
     */
    public function setRemoveMailingListAfterSent($removeMailingListAfterSent);
}