# README #

Mailing bundle for Symfony2

### What is this repository for? ###

* Manage emails campaigns
* Manage bounced emails

### Setup ###

Add to composer.json

```json
{
    "repositories": [
        {
            "type": "composer",
            "url": "http://satis.wearebab.com"
        }
    ]
}
```
And run

```
composer require comitium5/common-widgets-bundle --prefer-dist
```

Add your bundle instance on AppKernel.php as usual

```php
public function registerBundles()
{
    $bundles = array(
        ...
        new Comitium5\MailingBundle\Comitium5MailingBundle(),
    )
}
```
Set the bundle required configuration properly

```yaml
comitium5_mailing:
    smtp_host: some_smtp_host #smtp.gmail.com
    smtp_port: some_smtp_port #465
    smtp_user: user_email
    smtp_password: user_password
    smtp_security: ~ #ssl or ~
    imap_connection_string: valid_imap_string #"{imap.gmail.com:993/imap/ssl}INBOX"
    imap_user: user_email
    imap_password: user_password
```

Import routing /app/config/routing.yml

```yaml
comitium5_mailing:
    resource: "@Comitium5MailingBundle/Resources/config/routing.yml"
```