<?php

namespace Comitium5\MailingBundle\Model\Campaign;

use Comitium5\MailingBundle\Model\Core\ObjectValue;

/**
 * Class CampaignStateValue
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Model\Campaign
 */
class CampaignStateValue extends ObjectValue
{
    /**
     * CampaignStatValue constructor.
     * @param $value
     */
    public function __construct($value)
    {
        $this->checkValidValue($value);

        $this->value = $value;
    }

    /**
     * @param $value
     * @return bool
     */
    private function checkValidValue($value)
    {
        $valid = [
            CampaignInterface::STATE_DRAFT,
            CampaignInterface::STATE_READY,
            CampaignInterface::STATE_SENDING,
            CampaignInterface::STATE_SENT,
            CampaignInterface::STATE_PAUSE,
        ];

        if (!in_array($value, $valid)) {
            throw new \InvalidArgumentException();
        }
    }
}