<?php

namespace Comitium5\MailingBundle\Event;

use Comitium5\MailingBundle\Model\BouncedList\BouncedListInterface;
use Symfony\Component\EventDispatcher\Event;

/**
 * Class BouncedEmailEvent
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Event
 */
class BouncedEmailEvent extends Event
{
    const POST_CREATE = "comitium5_mailing.event.bounced_email.post_create";

    /**
     * @var BouncedListInterface
     */
    protected $bouncerList;

    /**
     * BouncerEvent constructor.
     * @param BouncedListInterface $bouncerList
     */
    public function __construct(BouncedListInterface $bouncerList)
    {
        $this->bouncerList = $bouncerList;
    }

    /**
     * @return BouncedListInterface
     */
    public function getBouncerList()
    {
        return $this->bouncerList;
    }
}