<?php

namespace Comitium5\MailingBundle\Tests\Parser;

use Comitium5\MailingBundle\Services\Bouncer\BouncedCommand;
use Comitium5\MailingBundle\Services\Parser\BouncerParser;
use Comitium5\MailingBundle\Services\Reader\ImapReader;
use PHPUnit\Framework\TestCase;

/**
 * Class BouncerParserTest
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Tests\Parser
 */
class BouncerParserTest extends TestCase
{
    /**
     * @expectedException \Exception
     */
    public function testParseException()
    {
        $parser = new BouncerParser();
        $parser->parse("foo");
    }

    public function testParse()
    {
        $reader = $this
            ->getMockBuilder(ImapReader::class)
            ->disableOriginalConstructor()
            ->getMock();

        $bodies = [
            //"Foo bouncer email <html></html>",
            "Tu mensaje no se ha entregado a oscarjg19-fail@yahoo.es porque no se ha enc=\r\n
            ontrado la direcci=C3=B3n. Comprueba que no haya erratas ni espacios innece=\r\n
            sarios y vuelve a intentarlo.\r\n
            \r\n
            \r\n
            \r\n
            La respuesta fue:\r\n
            \r\n
            
            554 delivery error: dd This user doesn't have a yahoo.es
             account (oscarjg19=\r\n
            -fail@yahoo.es) [0] - mta1167.mail.ir2.yahoo.com\r\n
            \r\n
            --001a114ba89c354d1d054e362ca0\r\n
            Content-Type: text/html; charset=UTF-8\r\n
            Content-Transfer-Encoding: quoted-printable\r\n
            \r\n
            \r\n
            \"\"\"
             <html></html>",
            "The error that the other server returned was:
             550-5.1.1 The email account that you tried to reach does not exist. Please try
             550-5.1.1 double-checking the recipient's email address for typos or
             550-5.1.1 unnecessary spaces. Learn more at
             550 5.1.1  https://support.google.com/mail/?p=NoSuchUser r2si23129710wjf.60 - gsmtp
             CS_EMAIL: foo@bar.com
             CS_CAMPAIGN_ID: 580f8b4368568
             X-Gm-Message-State: ABUngveLJgLpSLPcBDImiCY5WxR/iNnWG58muJX8d5U0m+Tt6IXx6XcKavy4x/SqOp8BQA==
             <html></html>",

        ];

        $parsedDataExpected = [
            //new BouncedCommand("", "", null, "No reason found"),
            new BouncedCommand("", "", "554", "transaction failed (or, in the case of a connectionopening response, no SMTP service here)"),
            new BouncedCommand("580f8b4368568", "foo@bar.com", "5.1.1", "Bad destination mailbox address")
        ];

        $reader
            ->method("getBodies")
            ->will($this->returnValue($bodies));

        $parser = new BouncerParser();

        $parsedData = $parser->parse($reader);

        $this->assertEquals($parsedData, $parsedDataExpected);
    }
}