<?php

namespace Comitium5\MailingBundle\Model\Core;

use Comitium5\MailingBundle\Model\Campaign\CampaignInterface;

/**
 * Class EmailCampaignTrait
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Model\Core
 */
trait EmailCampaignTrait
{
    /**
     * @var CampaignInterface
     */
    protected $campaign;

    /**
     * @var string
     */
    protected $email;

    /**
     * @return mixed
     */
    public function getCampaign()
    {
        return $this->campaign;
    }

    /**
     * @param CampaignInterface $campaign
     * @return $this
     */
    public function setCampaign(CampaignInterface $campaign)
    {
        $this->campaign = $campaign;

        return $this;
    }

    /**
     * @return mixed
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param mixed $email
     * @return $this
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }
}