<?php

namespace Comitium5\MailingBundle\Model\Campaign;

use Comitium5\MailingBundle\Model\Core\ObjectValue;

/**
 * Class CampaignStatValue
 *
 * @author Óscar Jiménez <oscarjg19.developer@gmail.com>
 * @package Comitium5\MailingBundle\Model\Campaign
 */
class CampaignStatValue extends ObjectValue
{
    /**
     * CampaignStatValue constructor.
     * @param $value
     */
    public function __construct($value)
    {
        $this->checkValidValue($value);

        $this->value = $value;
    }

    /**
     * @param $value
     * @return bool
     */
    private function checkValidValue($value)
    {
        $valid = [
            CampaignStatsInterface::CLICK,
            CampaignStatsInterface::BOUNCED,
            CampaignStatsInterface::OPEN,
        ];

        if (!in_array($value, $valid)) {
            throw new \InvalidArgumentException();
        }
    }
}